#include <windows>
#pragma option push -a1
#include <setupapi>
#pragma option pop
#include <assert>
#include <iostream>

using namespace std;

void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete [] x;
  x = NULL;
}
//---------------------------------------------------------
GUID classGuid;
HMODULE hHidLib;
DWORD /*unsigned long*/ memberIndex = 0;
DWORD deviceInterfaceDetailDataSize;
DWORD requiredSize;

HDEVINFO deviceInfoSet;
SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;

int main(){
    //Odwzorowanie identyfikatora biblioteki HID.dll w przestrze adresow gwnego procesu
  hHidLib = LoadLibrary("C:\\Windows\\system32\\HID.DLL");
  if (!hHidLib)
    displayError("Bd doczenia biblioteki HID.DLL.");
    //Pobranie adresu funkcji eksportowej HidD_GetHidGuid() 
  void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);
  /*(void __stdcall*/(FARPROC&) HidD_GetHidGuid = GetProcAddress(hHidLib,
                                                      "HidD_GetHidGuid");
   if (!HidD_GetHidGuid){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono identyfikatora GUID");
   }
       //Wywoanie funkcji HidD_GetHidGuid()
   HidD_GetHidGuid(&classGuid);
   //Procedury enumeracji urzdze
   deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE)
      displayError("Nie zidentyfikowano podczonych urzdze.\n");

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);

   while(SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL, &classGuid,
                                     memberIndex, &deviceInterfaceData)){
       memberIndex++; //inkrementacja numeru interfejsu

       SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);

       deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];

       deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);

       if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                       deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
                       &requiredSize, NULL)){
           releaseMemory(deviceInterfaceDetailData);
           //SetupDiDestroyDeviceInfoList(deviceInfoSet);
           //displayError("Nie mona pobra informacji o interfejsie.\n");
       }
       // deviceInterfaceDetailData->DevicePath jest czem symbolicznym do interfejsu urzdzenia
       cout << deviceInterfaceDetailData->DevicePath << endl;
       releaseMemory(deviceInterfaceDetailData);
    };//koniec while

   SetupDiDestroyDeviceInfoList(deviceInfoSet);
   FreeLibrary(hHidLib);
   cout << endl;
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------

